VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Begin VB.Form Main 
   Caption         =   "SeerServer"
   ClientHeight    =   2940
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4710
   LinkTopic       =   "Form1"
   ScaleHeight     =   196
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   314
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdClearHistory 
      Caption         =   "Clear Log"
      Height          =   585
      Left            =   1980
      TabIndex        =   2
      Top             =   2190
      Width           =   1260
   End
   Begin VB.TextBox txtHist 
      Height          =   1950
      Left            =   75
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   1
      Top             =   90
      Width           =   4470
   End
   Begin MSWinsockLib.Winsock Winsock 
      Index           =   0
      Left            =   90
      Top             =   2235
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
      Protocol        =   1
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Close"
      Height          =   585
      Left            =   3300
      TabIndex        =   0
      Top             =   2190
      Width           =   1260
   End
End
Attribute VB_Name = "Main"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim hs As HomeSeer.Application
Dim ClientCount As Integer

Private Sub cmdClearHistory_Click()
    txtHist = "Log Cleared" & vbCrLf
End Sub

Private Sub cmdExit_Click()
    Dim i As Integer
    For i = 0 To ClientCount
        Winsock(i).Close
    Next i
    Set Main = Nothing
    Unload Me
End Sub

Private Sub Form_Load()
    Dim HostName As String, HostInPort As String, HostOutPort As String
    Dim i As Integer, inifile As String, tmpCtl As Control
    inifile = App.Path & "\SeerServer.ini"
    Set hs = New HomeSeer.Application
    hs.RegisterEventCB 3, Me
    txtHist = "Server started: " & Format(Date, "mm/dd/yyyy") & vbCrLf
    ClientCount = -1: i = 0
    Do While ClientCount = -1
        i = i + 1
        fReadValue inifile, "Options", "Host" & i & "Name", "S", "err", HostName
        fReadValue inifile, "Options", "Host" & i & "InPort", "S", "err", HostInPort
        fReadValue inifile, "Options", "Host" & i & "OutPort", "S", "err", HostOutPort
        If HostName <> "err" And HostInPort <> "err" And HostOutPort <> "err" Then
            Load Winsock(i)
            Winsock(i).RemoteHost = HostName
            Winsock(i).RemotePort = CInt(HostInPort)
            Winsock(i).Bind CInt(HostOutPort)
            txtHist = txtHist & "Socket" & i & ": " & HostName & "," & HostInPort & "," & HostOutPort & vbCrLf
        Else
            ClientCount = i - 1
        End If
    Loop
End Sub

Private Sub Form_Resize()
    Dim x As Integer, y As Integer
    If Main.WindowState <> vbMinimized Then
        x = Main.ScaleWidth
        y = Main.ScaleHeight
        If x < 314 Then x = 314: Main.Width = 4830
        If y < 196 Then y = 196: Main.Height = 3345
        Me.txtHist.Width = x - 15
        Me.txtHist.Height = y - 64
        Me.cmdExit.Top = y - 48
        Me.cmdExit.Left = x - 92
        Me.cmdClearHistory.Top = y - 48
        Me.cmdClearHistory.Left = x - 180
    End If
End Sub

Private Sub Winsock_DataArrival(Index As Integer, ByVal bytesTotal As Long)
    Dim t As String, s As String
    Winsock(Index).GetData s
    t = hsgo(s)
    If t <> "ok" Then Winsock(Index).SendData t
End Sub

Public Function hsgo(s As String) As String
    Dim c As String, cmd As String, i As Integer, j As Integer
    If Len(txtHist) > 8000 Then txtHist = ""
    c = LCase(Left(s, 2))
    txtHist = Me.txtHist & "Request: " & s & vbCrLf
    If c = "ex" Then
        hs.ExecX10 Mid(s, 3, 3), Right(s, Len(s) - 5)
        txtHist = Me.txtHist & "HS Execute: " & Mid(s, 3, 3) & " - " & Right(s, Len(s) - 5) & vbCrLf
        hsgo = "ok": Exit Function
    End If
    If c = "ev" Then
        hs.TriggerEvent Right(s, Len(s) - 2)
        txtHist = Me.txtHist & "HS Event: " & Right(s, Len(s) - 2) & vbCrLf
        hsgo = "ok": Exit Function
    End If
    If c = "st" Then
        c = StatusCode(hs.DeviceStatus(Mid(s, 3, 3)))
        txtHist = Me.txtHist & "HS Status: " & Mid(s, 3, 3) & " - " & c & vbCrLf
        hsgo = c: Exit Function
    End If
    If c = "ir" Then
        hs.SendIR Right(s, Len(s) - 2)
        txtHist = Me.txtHist & "IR Event: " & Right(s, Len(s) - 2) & vbCrLf
        hsgo = "ok": Exit Function
    End If
    If c = "cm" Then
        c = "ok": cmd = Right(s, Len(s) - 4)  'preceded by "cmd:"
        If LCase(cmd) = "sunrise" Then c = "Sunrise: " & hs.SunRise
        If LCase(cmd) = "sunset" Then c = "Sunset: " & hs.SunSet
        If LCase(cmd) = "systemuptime" Then c = "System UpTime: " & hs.SystemUpTime
        If Left(LCase(cmd), 9) = "writelog:" Then hs.WriteLog "Info", Right(cmd, Len(cmd) - 9)
        If LCase(cmd) = "clearlog" Then hs.ClearLog
        If Left(LCase(cmd), 7) = "launch:" Then c = hs.Launch(Right(cmd, Len(cmd) - 7)): c = "ok"
        If LCase(cmd) = "getapppath" Then c = "AppPath: " & hs.GetAppPath
        If LCase(cmd) = "getipaddress" Then c = "HomeSeer IP: " & hs.GetIPAddress
        If LCase(cmd) = "interfaceversion" Then c = "Interface " & hs.InterfaceVersion
        If LCase(cmd) = "version" Then c = "Homeseer " & hs.version
        If Left(LCase(cmd), 4) = "runex:" Then
            cmd = Right(cmd, Len(cmd) - 4)
            i = InStr(1, cmd, ";") - 1: j = InStr(i + 2, cmd, ";") - 1
            c = hs.RunEx(Left(cmd, i), Mid(cmd, i + 2, j), Right(cmd, Len(cmd) - j))
        End If
        If Left(LCase(cmd), 5) = "send:" Then
            cmd = Right(cmd, Len(cmd) - 5)
            i = InStr(1, cmd, ";") - 1
            hs.Keys Right(cmd, Len(cmd) - i - 1), Left(cmd, i), 1
        End If
        hsgo = c: Exit Function
    End If
    If c = "me" Then
        c = "ok": cmd = Right(s, Len(s) - 5) ' preceded by "media"
        If LCase(cmd) = "mute:true" Then hs.MEDIAMute True
        If LCase(cmd) = "mute:false" Then hs.MEDIAMute False
        If LCase(cmd) = "pause" Then hs.MEDIAPause
        If LCase(cmd) = "play" Then hs.MEDIAPlay
        If LCase(cmd) = "stop" Then hs.MEDIAStop
        If Left(LCase(cmd), 7) = "volume:" Then hs.MEDIAVolume = (Right(cmd, Len(cmd) - 7))
        If Left(LCase(cmd), 9) = "filename:" Then hs.MEDIAFilename = (Right(cmd, Len(cmd) - 9))
        If LCase(cmd) = "filename" Then c = hs.MEDIAFilename
        If LCase(cmd) = "isplaying" Then c = hs.MEDIAIsPlaying
        If Left(LCase(cmd), 10) = "setvolume:" Then i = CInt(Right(cmd, Len(cmd) - 10)): hs.SetVolume i, i
        hsgo = c: Exit Function
    End If
    If c = "vo" Then
        c = "ok": cmd = Right(s, Len(s) - 6) ' preceded by "voice:"
        If Left(LCase(cmd), 6) = "speak:" Then hs.Speak (Right(cmd, Len(cmd) - 6))
        If LCase(cmd) = "mutespeech:true" Then hs.MuteSpeech = True
        If LCase(cmd) = "mutespeech:false" Then hs.MuteSpeech = False
        hsgo = c: Exit Function
    End If
    If c = "de" Then
        c = "ok": cmd = Right(s, Len(s) - 6) ' preceded by "device:"
        If LCase(cmd) = "count" Then c = hs.DeviceCount
        If Left(LCase(cmd), 5) = "name:" Then c = GetDevInfo("name", CInt(Right(cmd, Len(cmd) - 5)))
        If Left(LCase(cmd), 9) = "location:" Then c = GetDevInfo("location", CInt(Right(cmd, Len(cmd) - 9)))
        If Left(LCase(cmd), 5) = "code:" Then c = GetDevInfo("code", CInt(Right(cmd, Len(cmd) - 5)))
        If Left(LCase(cmd), 8) = "can_dim:" Then c = GetDevInfo("can_dim", CInt(Right(cmd, Len(cmd) - 8)))
        hsgo = c: Exit Function
    End If
    If c = "et" Then
        c = "ok": cmd = Right(s, Len(s) - 3) ' preceded by "et:"
        If LCase(cmd) = "count" Then c = hs.EventCount
        If Left(LCase(cmd), 5) = "name:" Then c = hs.GetEvent(CInt(Right(cmd, Len(cmd) - 5))).Name
        hsgo = c: Exit Function
    End If
    If c = "ma" Then
        c = "ok": cmd = Right(s, Len(s) - 3) ' preceded by "mail:"
        If LCase(cmd) = "count" Then c = hs.MailMsgCount
        If Left(LCase(cmd), 5) = "from:" Then c = hs.MailFrom(CInt(Right(cmd, Len(cmd) - 5)))
        If Left(LCase(cmd), 5) = "date:" Then c = hs.MailDate(CInt(Right(cmd, Len(cmd) - 5)))
        If Left(LCase(cmd), 5) = "text:" Then c = hs.MailText(CInt(Right(cmd, Len(cmd) - 5)))
        If Left(LCase(cmd), 8) = "subject:" Then c = hs.MailSubject(CInt(Right(cmd, Len(cmd) - 8)))
        If Left(LCase(cmd), 5) = "send:" Then SendMail cmd
        hsgo = c: Exit Function
    End If

End Function
            
Public Sub HSEvent(params As Variant)
End Sub

Public Function StatusCode(s As Integer) As String
    StatusCode = "unknown"
    If s = 2 Then StatusCode = "on"
    If s = 3 Then StatusCode = "off"
End Function

Private Function GetDevInfo(info As String, devnum As Integer) As String
    Dim device
    Set device = hs.GetDevice(devnum)
    If info = "name" Then GetInfo = device.Name
    If info = "location" Then GetInfo = device.location
    If info = "code" Then GetInfo = device.hc & Format(device.dc, "00")
    If info = "can_dim" Then GetInfo = device.can_dim
End Function

Private Sub SendMail(cmd)
    Dim mto As String, mfrom As String, msubject As String, message As String
    Dim i As Integer, j As Integer
    i = InStr(1, cmd, "~") - 1
    mto = Left(cmd, i): cmd = Right(cmd, Len(cmd) - (i + 2))
    i = InStr(1, cmd, "~")
    mfrom = Left(cmd, i): cmd = Right(cmd, Len(cmd) - (i + 2))
    i = InStr(1, cmd, "~")
    msubject = Left(cmd, i): cmd = Right(cmd, Len(cmd) - (i + 2))
    mmessage = cmd
    hs.SendEmail mto, mfrom, msubject, message
End Sub
