Attribute VB_Name = "Declarations"
Option Explicit

'These are global variables and functions for the Homepanel application
Type POINTAPI       'This Data Type is used to call API function requiring X,Y coordinates
    X As Long
    y As Long
End Type

'Send a message to a WINAPI function.  Used locally in the module
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long

'WinAPI GDI function to create a Polygon Graphic region based on the PointAPI type array
'Right now only used for  Section One's odd shaped buttons.
Declare Function CreatePolygonRgn Lib "gdi32" (lpPoint As POINTAPI, ByVal nCount As Long, ByVal nPolyFillMode As Long) As Long

'WinAPI GDI function to create a custom font.  Used for rotated font in Section One.
Declare Function CreateFont Lib "gdi32" Alias "CreateFontA" (ByVal H As Long, ByVal W As Long, ByVal E As Long, ByVal o As Long, ByVal W As Long, ByVal i As Long, ByVal u As Long, ByVal S As Long, ByVal c As Long, ByVal OP As Long, ByVal cp As Long, ByVal Q As Long, ByVal PAF As Long, ByVal F As String) As Long

'WinAPI GDI function to create the transparent section of the buttons for Section One.
Declare Function SetWindowRgn Lib "user32" (ByVal hwnd As Long, ByVal hRgn As Long, ByVal bRedraw As Boolean) As Long

'WinAPI GDI function to select and delete the button objects created for Section One.
Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long

'Flags to indicate if the given Sections are accessible.
Public Section1 As Boolean, Section2 As Boolean
Public Section3 As Boolean, Section4 As Boolean
Public DefSection As Long                       'Default Section to show at program start

Private Const CB_DIR = &H145
Private Const CB_RESETCONTENT = &H14B

Private Const DDL_READWRITE = &H0
Private Const DDL_READONLY = &H1
Private Const DDL_HIDDEN = &H2
Private Const DDL_SYSTEM = &H4
Private Const DDL_DIRECTORY = &H10
Private Const DDL_ARCHIVE = &H20
Private Const DDL_DRIVES = &H4000
Private Const DDL_EXCLUSIVE = &H8000&
Private Const DDL_POSTMSGS = &H2000
Private Const DDL_FLAGS = DDL_ARCHIVE Or DDL_DIRECTORY

Public Const ALTERNATE = 1
Public Const WINDING = 2
Public Const CLIP_LH_ANGLES = 16
Public Const PI = 3.14159625
Public Const PI_180 = PI / 180#

Public PreserveFormStyle As Long            '???
Public Const GWL_STYLE = (-16)
Public Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long) As Long
Public Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Public Declare Function MoveWindow Lib "user32" (ByVal hwnd As Long, ByVal X As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bRepaint As Long) As Long

'window styles for get/set window long
Public Const WS_CAPTION = &HC00000
Public Const WS_OVERLAPPED = &H0&
Public Const WS_THICKFRAME = &H40000

Public Function RGBS(RGBval As Long) As String
    'Given a RGB value as a long this will return the three hex values for R G and B
    RGBS = Val("&H" + Right$(Hex$(RGBval), 2)) & "," & Val("&H" + Mid$(Hex$(RGBval), 3, 2)) & "," & Val("&H" + Left$(Hex$(RGBval), 2))
End Function

Public Sub MakeBorderstyle_vbBSNone(frm As Form)
    'This will turn off any border and make the form full screen
    Dim L As Long
    L = GetWindowLong(frm.hwnd, GWL_STYLE)
    PreserveFormStyle = L
    L = L And Not (WS_OVERLAPPED Or WS_CAPTION Or WS_THICKFRAME)
    Call SetWindowLong(frm.hwnd, GWL_STYLE, L)
    Call MoveWindow(frm.hwnd, frm.ScaleX(frm.Left, vbTwips, vbPixels), _
        frm.ScaleY(frm.Top, vbTwips, vbPixels), _
        frm.ScaleX(frm.Width - 10, vbTwips, vbPixels), _
        frm.ScaleY(frm.Height - 10, vbTwips, vbPixels), True)
End Sub

Public Sub MakeBorderstyle_vbSizable(frm As Form)
    'This will change a form to be sizable
    Dim L As Long
    L = GetWindowLong(frm.hwnd, GWL_STYLE)
    Call SetWindowLong(frm.hwnd, GWL_STYLE, PreserveFormStyle)
    Call MoveWindow(frm.hwnd, frm.ScaleX(frm.Left, vbTwips, vbPixels), _
        frm.ScaleY(frm.Top, vbTwips, vbPixels), _
        frm.ScaleX(frm.Width + 10, vbTwips, vbPixels), _
        frm.ScaleY(frm.Height + 10, vbTwips, vbPixels), True)
End Sub

Public Function GetDriveInfo(Combo1 As Control, searchPath As String, Index As String) As Long
    'This function return the data from a drive requested - it can be files, directories, etc
    'This will return the data to the control specified in Combo1
    Dim numfound As Long, DDL_FLAGS As Long
    Select Case Index
       Case "normal": DDL_FLAGS = DDL_EXCLUSIVE Or DDL_ARCHIVE
       Case "normalhidden": DDL_FLAGS = DDL_EXCLUSIVE Or DDL_ARCHIVE Or DDL_DIRECTORY
       Case "hidden": DDL_FLAGS = DDL_EXCLUSIVE Or DDL_HIDDEN
       Case "system": DDL_FLAGS = DDL_EXCLUSIVE Or DDL_SYSTEM
       Case "folder": DDL_FLAGS = DDL_EXCLUSIVE Or DDL_DIRECTORY
       Case "drives": DDL_FLAGS = DDL_EXCLUSIVE Or DDL_DRIVES
       Case Else
    End Select
    
    'clear and populate the combo
    Call SendMessage(Combo1.hwnd, CB_RESETCONTENT, 0&, ByVal 0&)
    numfound = SendMessage(Combo1.hwnd, CB_DIR, DDL_FLAGS, ByVal searchPath)
    GetDriveInfo = numfound
End Function

Public Function boolGetDirectory(ByVal strPath As String, arrPntr() As String, Optional FileAttr As VbFileAttribute = vbDirectory, Optional DirnamesOnly As Boolean = False) As Boolean
    'Given the path in strPath, this return the list of directories and the flag to indicate if the directory exists
    Dim strFile As String, lngIndex As Long
    Dim boolDirectoryOnly As Boolean, boolGetName As Boolean

    On Error GoTo Err_boolGetDirectory

    If Right$(strPath, 1) <> "\" Then strPath = strPath & "\"
    boolDirectoryOnly = (FileAttr = vbDirectory) And (DirnamesOnly = True)
    boolGetName = True
    strFile = Dir$(strPath, FileAttr)
    Do While (Len(strFile) <> 0)
        If (strFile <> ".") And (strFile <> "..") Then
            If boolDirectoryOnly Then
                boolGetName = (GetAttr(strPath & strFile) And vbDirectory) = vbDirectory
            End If
            If boolGetName Then
                ReDim Preserve arrPntr(lngIndex) As String
                arrPntr(lngIndex) = strFile
                lngIndex = lngIndex + 1&
            End If
        End If
        strFile = Dir
    Loop
    boolGetDirectory = (lngIndex >= 0)

Exit_boolGetDirectory:
    On Error Resume Next
    Exit Function

Err_boolGetDirectory:
    If (MsgBox("Error #" & Err.Number & vbCrLf & Err.Description, vbRetryCancel + vbExclamation) = vbRetry) Then Resume
    Resume Exit_boolGetDirectory
End Function

Public Function DecodeFile(S As String) As String
    'This function takes a filename that has the full path and extracts just the filename
    DecodeFile = Right(S, InStr(1, StrReverse(S), "\") - 1)
End Function

Public Function DecodeTitle(S As String) As String
    'This function takes a filename that has the full path and extracts just the title
    '(without the extension)
    Dim i As Long
    i = InStr(1, StrReverse(S), "\") - 1
    If i <> 0 Then
        DecodeTitle = Mid(S, Len(S) - (i - 1), (i - 4))
    Else
        DecodeTitle = S
    End If
End Function

